using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Resources;
using System.Text;
using Microsoft.ContentManagement.Publishing;
using Microsoft.ContentManagement.Publishing.Extensions.Placeholders;

namespace ContosoNet.Site_Templates
{
	/// <summary>
	/// Summary description for External_Home.
	/// </summary>
	public class Home : System.Web.UI.Page
	{
		// Controls on the page
		protected Telerik.WebControls.RadEditorPlaceHolderControl RadEditorPlaceHolderControl1;
		protected Microsoft.ContentManagement.WebControls.RobotMetaTag RobotMetaTag1;
		protected System.Web.UI.WebControls.Label CareerCenterLabel1;
		protected System.Web.UI.WebControls.Label CareerCenterLabel2;
		protected System.Web.UI.HtmlControls.HtmlImage BestPlacesImage;
		protected System.Web.UI.HtmlControls.HtmlImage GoImage;
		protected System.Web.UI.WebControls.Label BestLabel;
		protected System.Web.UI.HtmlControls.HtmlAnchor GoLink;

		protected LocalizationManager localizationManager;

		private void Page_Load(object sender, System.EventArgs e)
		{
			localizationManager = new LocalizationManager();
			localizationManager.CheckForLocalizedPosting ();

			CareerCenterLabel1.Text = localizationManager.GetString ("homePageCareerCenterLabel1");
			CareerCenterLabel2.Text = localizationManager.GetString ("homePageCareerCenterLabel2");
			BestLabel.Text = localizationManager.GetString ("homePageBestLabel");
			BestPlacesImage.Src = localizationManager.TranslateImageUrl (BestPlacesImage.Src);
			GoImage.Src = localizationManager.TranslateImageUrl (GoImage.Src);
			GoLink.HRef = SiteValues.ExternalCareerCenterUrl;
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
